importScripts('https://storage.googleapis.com/workbox-cdn/releases/5.0.0/workbox-sw.js');

// workbox.setConfig({ debug: true });
// workbox.setConfig({ mode: 'production' });
workbox.core.skipWaiting();
workbox.core.clientsClaim();

// workbox.routing.registerRoute(
//     new RegExp('https://fonts.*|.(?:ttf|woff|woff2)$'),
//     new workbox.strategies.CacheFirst({ cacheName: 'fonts' })
// );

workbox.routing.registerRoute(new RegExp('/(?:icon-|js|css|img)'), new workbox.strategies.CacheFirst());
workbox.routing.registerRoute(new RegExp('.(?:jpg|jpeg|png|gif|svg)$'), new workbox.strategies.CacheFirst());
workbox.routing.registerRoute(new RegExp('/'), new workbox.strategies.NetworkFirst({ cacheName: 'pages' }));
workbox.routing.registerRoute(new RegExp('.*(?:googleapis|gstatic).com.*$'), new workbox.strategies.NetworkFirst({ cacheName: 'google' }));

workbox.precaching.precacheAndRoute([{ url: 'offline', revision: Date.now() }].concat([{"revision":"7f20e55cd1ddbfce1c8e08c5622af6b9","url":"100.png"},{"revision":"da8b034c50b9da2ab4fff0584a18db29","url":"114.png"},{"revision":"342dd7829f09b27f562365706018344a","url":"120.png"},{"revision":"8b7f6e63922beb831de18010e0ad7e56","url":"144.png"},{"revision":"afa3e3021a512f9f585366627091c43d","url":"152.png"},{"revision":"a8209e199ee0eda80d56cd72b41115d7","url":"196.png"},{"revision":"fc854620fc5fca28e85d98b308306b38","url":"256.png"},{"revision":"3d4df8c148134ceb3a165acab1e4703d","url":"32.png"},{"revision":"cb95a92e96b8169dd48de4ed52d50fde","url":"48.png"},{"revision":"3a3082775c73eec958bd6272bb9b866f","url":"512.png"},{"revision":"f98f921beb5c0b6b59afb6a8ae9696c7","url":"76.png"},{"revision":"32336e830832d71652f00c631bad677d","url":"88.png"},{"revision":"2df0557c05491e21d09c0ec68d7f380b","url":"build/assets/_baseIsEqual.012a6631.js"},{"revision":"a84ebee935ed9bc10099961b4ff7d3e6","url":"build/assets/ActionMessage.05a5d7f1.js"},{"revision":"cf6c981eb16c1b178038d5e18a1ca3e3","url":"build/assets/ActionSection.1d08ebc5.js"},{"revision":"0cc0270f84a5fb8634b03d14f574d450","url":"build/assets/Adjustment.b1a98f14.js"},{"revision":"585827c77be1e57821766994b3a5c658","url":"build/assets/AdminLayout.48d4640f.js"},{"revision":"93ccb07efd1a80120ca8f06dbbe9a88b","url":"build/assets/Alerts.bf106488.js"},{"revision":"be755c6b1511f9ad3c1e7f2036efbbf6","url":"build/assets/ApiTokenManager.1eae0dbe.js"},{"revision":"c22de0d24b55919ade37f2673034dcec","url":"build/assets/app.1d18be67.js"},{"revision":"c2bbad40f9932736ea89f77a433451ba","url":"build/assets/app.364f3fa0.css"},{"revision":"6386aa4eb1595456a320d3853586c04f","url":"build/assets/ApplicationLogo.1fe72727.js"},{"revision":"a9a4a70bc23fda7ca1d6d53f31c0c549","url":"build/assets/ApplicationMark.7842ca77.js"},{"revision":"32ee5d5d077e55d675e718342df6c45f","url":"build/assets/AuthenticationCard.ef726d3d.js"},{"revision":"32eb17a59c417dba736c9d9593029476","url":"build/assets/AuthenticationCardLogo.3dbd9ed1.js"},{"revision":"373eba5da1c52cfe00373d2955cd26b9","url":"build/assets/AutoComplete.326a6b44.js"},{"revision":"ecfb110b3b7366da7f23580e41b99349","url":"build/assets/Button.7307f1c2.js"},{"revision":"93f03181d8d1ef8ada2ad05d06416863","url":"build/assets/CheckBox.a797a746.js"},{"revision":"caf7767b03b3c034cba68a72c2e7cadf","url":"build/assets/Checkbox.b4f614b8.js"},{"revision":"c7440ecfc80c71d15e2aeb23fa3801ad","url":"build/assets/Checkin.24ac0e46.js"},{"revision":"af68202d6299a9c64846809809de9d20","url":"build/assets/Checkout.96140d85.js"},{"revision":"e5e18744c134cf123dd98f61beeed202","url":"build/assets/ConfirmPassword.7bc056cb.js"},{"revision":"6d2a9d9e38a5599e183959260c733f51","url":"build/assets/DangerButton.a61fba0f.js"},{"revision":"ed0e738422b23a9e623c83f2bfa30415","url":"build/assets/DeleteUserForm.5f024577.js"},{"revision":"1b5fe21b3a27bc94f974fdfe4e70989e","url":"build/assets/Details.51d886ab.js"},{"revision":"66f341b75d319e285db6751cf0de40d7","url":"build/assets/Details.70cb113b.js"},{"revision":"4be997ae32e9a1fe41223aac719328c4","url":"build/assets/Details.a0e40b96.js"},{"revision":"7cf9333b616a37c3addd5ad940518dbe","url":"build/assets/Details.ad70c945.js"},{"revision":"c940f72eea9506c003fc13217480b065","url":"build/assets/Details.d7bfb693.js"},{"revision":"ac66bcc8a703e94d79627b2042407b03","url":"build/assets/Dialog.0c751675.js"},{"revision":"91df47e170d6431b2f335e51dad01d5c","url":"build/assets/DialogModal.6b90341c.js"},{"revision":"048e58a5001817dda098d1f717ff37a6","url":"build/assets/DropdownLink.3980a138.js"},{"revision":"29450dbc8ea58a6c0dacf907725e59c2","url":"build/assets/Error.915c79f2.js"},{"revision":"0130a69be02df287cb61ead078bebaf0","url":"build/assets/FileInput.81da7ad1.js"},{"revision":"a19f543001cee1a0c8d46052b569e906","url":"build/assets/ForgotPassword.3ce0ab46.js"},{"revision":"316b430d6b8e80f7cbdd6c3a6759f604","url":"build/assets/Form.027674cc.js"},{"revision":"867117c614409f023b6ded3a2c91f1ac","url":"build/assets/Form.1d9b21eb.js"},{"revision":"a879bfa79584cae5e715879804775966","url":"build/assets/Form.21678302.js"},{"revision":"f87f881ba4d01bf75d3a29766fba37b9","url":"build/assets/Form.34bf9081.js"},{"revision":"45fc76458e9afef4ed6364e7466a6da8","url":"build/assets/Form.462ebbfc.js"},{"revision":"0ad2c7e29ba5c135877bd3fc38e6a959","url":"build/assets/Form.8824daba.js"},{"revision":"0c0b3d6fa1ef3ccb3942348be820101e","url":"build/assets/Form.88d5e4a1.js"},{"revision":"9afea9634876e1881936bdcc41d1948c","url":"build/assets/Form.9d02f912.js"},{"revision":"fa0d85a4bd39fd7c662a9732d67e821b","url":"build/assets/Form.a109a7f3.js"},{"revision":"4a9b7abe95746bac3b3dda73a7ae5411","url":"build/assets/Form.a23b3753.js"},{"revision":"fa997eb2e740055ccfda7bab545ba76f","url":"build/assets/Form.aecf68d1.js"},{"revision":"67a69820015f8e0afbd4b5e347c3f787","url":"build/assets/Form.b300246f.js"},{"revision":"20dc9443335409b043129bfabe4977fc","url":"build/assets/FormSection.5a5e7a36.js"},{"revision":"f765278a1a753d954bee8e746eb59ea1","url":"build/assets/Import.048a5553.js"},{"revision":"405fc0918d5a2e5055db6e6f53532e59","url":"build/assets/Import.15ae7899.js"},{"revision":"9b52a24579c8e5baac866281efc4f804","url":"build/assets/Import.34470f15.js"},{"revision":"823e411feae43410fe11a8b5393d3d8b","url":"build/assets/Import.67b0890e.js"},{"revision":"9f9a0c1b6714a771389b9ba69819aa51","url":"build/assets/Import.997da27a.js"},{"revision":"823e411feae43410fe11a8b5393d3d8b","url":"build/assets/Import.f71acb86.js"},{"revision":"823e411feae43410fe11a8b5393d3d8b","url":"build/assets/Import.fef10a5c.js"},{"revision":"d945a5d2cae084f2f616d087df5bc15d","url":"build/assets/Index.0108c387.js"},{"revision":"e22838f6810cd27c0485594e4e416d2b","url":"build/assets/Index.16827a27.js"},{"revision":"28a25b40c0884720c002fa429fbeb018","url":"build/assets/index.1f699fe1.js"},{"revision":"fcca27a25686dcb99609f3044e44415a","url":"build/assets/Index.2a92eeba.js"},{"revision":"fd9a3523604be624edb87ed04e8225b1","url":"build/assets/Index.2bd00c34.js"},{"revision":"14896263dbf2a02b0dace4ce1167c603","url":"build/assets/Index.2c216dbd.js"},{"revision":"2008a153008174b935339d0c743243cc","url":"build/assets/Index.45a90fea.js"},{"revision":"3a9d0a8b8061474f49ec8ba122b20743","url":"build/assets/Index.637eb578.js"},{"revision":"aa6255c559535f79562ba54d72fb1bc0","url":"build/assets/Index.7e1ace6c.js"},{"revision":"bb55f129eb4b9bc2b165f3182f9932af","url":"build/assets/Index.8b4a9553.js"},{"revision":"0fd3b0edd5edd6b229d326ee151b6939","url":"build/assets/Index.9282fb5f.js"},{"revision":"89faaa255daab7daa44f3855f627ab52","url":"build/assets/Index.ad0dc370.js"},{"revision":"ed6ae88f72bca0d7c0a6783ca46ea703","url":"build/assets/Index.aebfa00c.js"},{"revision":"890f187725da30ef048ee863b05f4b0e","url":"build/assets/Index.ba3d0294.js"},{"revision":"62a6f071c120de9b8132ec9a38af2846","url":"build/assets/Index.be6757e6.js"},{"revision":"b4bf972ba4ba871481166d3e0aa65542","url":"build/assets/Index.cccf2ddc.js"},{"revision":"4026860173f6ba5ab89992f8498857a7","url":"build/assets/Index.fdce6503.js"},{"revision":"a792325242de680dd4055a86adf2f814","url":"build/assets/Input.d118fd5d.js"},{"revision":"6455e23a1da57177bc57a68a1f26b654","url":"build/assets/InputError.16275fe4.js"},{"revision":"1d9c1be8631de61006df8ad1d07b1ae8","url":"build/assets/JsBarcode.429efe0e.js"},{"revision":"5303fa064179f454661bbd2d0e587440","url":"build/assets/Label.c4dd8960.js"},{"revision":"fe47b0973739705fbb1ca2aba9f95d57","url":"build/assets/LoadingButton.66f2f23d.js"},{"revision":"f3d1391a2f55eff0d9fb66e8917baa86","url":"build/assets/Login.aff7066b.js"},{"revision":"59d3b2e67132273cfd4de2afa3cbbbcb","url":"build/assets/LogoutOtherBrowserSessionsForm.845860a8.js"},{"revision":"2084226023a8de17ebc37fe5adfbbdcf","url":"build/assets/Modal.44ff45db.js"},{"revision":"4d65810025007932d940927071375c10","url":"build/assets/Pagination.f0529b79.js"},{"revision":"ce08b45b74933bfe061b2e871fdab1ed","url":"build/assets/PrivacyPolicy.9e53c8ad.js"},{"revision":"273d5f82f8e992a55b57174459e1a018","url":"build/assets/Register.4b5348e7.js"},{"revision":"3fc631bd644b344df8d2795d26f8e701","url":"build/assets/ResetPassword.62c5d581.js"},{"revision":"daa30c940bc0e1c921c01e607663df82","url":"build/assets/SearchFilter.5a6584fb.js"},{"revision":"06ba5b5fa6ab596222ee37b4a05651cb","url":"build/assets/SecondaryButton.24ca5592.js"},{"revision":"5fe9f614f2e37cbbe98a48ac5596e945","url":"build/assets/SectionBorder.a65d24ee.js"},{"revision":"de74452dd1840ad40250c1109a2aa061","url":"build/assets/SectionTitle.2d4a8b77.js"},{"revision":"3174db59f27fa026d45b8bea3115263a","url":"build/assets/SelectInput.c35fffde.js"},{"revision":"2336d692d7328df1f89fbbe06e750164","url":"build/assets/SelectVariantModal.ce799ae7.js"},{"revision":"8b30de82f6d968becd11d6299b2ab320","url":"build/assets/Show.6d5aeb01.js"},{"revision":"a6e72eee70e3d1962db3658051bf58d4","url":"build/assets/Show.7e16b34d.js"},{"revision":"bb466a38ca30cba1852dce37bd976dfd","url":"build/assets/Show.925b68f0.js"},{"revision":"f6e25ff7001bc148b9a2c073b349591b","url":"build/assets/Show.ad691710.js"},{"revision":"53a25a41db60f8af187ef432262e434a","url":"build/assets/Show.eeb25f98.js"},{"revision":"8edfc3b3c1fe9a967cd6c2ef048b1498","url":"build/assets/Show.fc8303d3.js"},{"revision":"6e603d695f4b2245a09d21aca8c13379","url":"build/assets/TermsOfService.77aa8631.js"},{"revision":"f98a73edd48446b2792298f3f58640f7","url":"build/assets/TextareaInput.85c00a3e.js"},{"revision":"4db88c8fa17d5547121ceafdef80ddab","url":"build/assets/TextInput.d3b05f64.js"},{"revision":"d7f71750dd53b9bd78ac80d5be589331","url":"build/assets/throttle.4084b557.js"},{"revision":"e1b27177399ac2392327119161690209","url":"build/assets/Trail.b5dcc7f2.js"},{"revision":"959a567440c00ecc3da3018db96d0e92","url":"build/assets/Transfer.53dbf718.js"},{"revision":"798471545e677943b1b6b52911d34e73","url":"build/assets/TrashedMessage.7625fccc.js"},{"revision":"bfb5534e81cb4e819a2dc89645f43579","url":"build/assets/TwoFactorAuthenticationForm.36213def.js"},{"revision":"3eb63f6ff963201e2740294bac6015af","url":"build/assets/TwoFactorChallenge.7fc54e68.js"},{"revision":"d47c9bba0c155bdd4fff3dd018bdfec2","url":"build/assets/UpdatePasswordForm.08511d9a.js"},{"revision":"1336ce37aa9f944f730edce4fafe7ed9","url":"build/assets/UpdateProfileInformationForm.d0de8961.js"},{"revision":"35422068e869375550172d32bb96aa2d","url":"build/assets/ValidationErrors.f24575c8.js"},{"revision":"d64caab2623601f79eceade36a150e8c","url":"build/assets/VerifyEmail.5d896ac4.js"},{"revision":"0286837190a4abce03b9b160303029a1","url":"css/app.css"},{"revision":"31659824417dff0dcc2825766ee74585","url":"js/app.js"},{"revision":"fcd590a0382a624b4dadb8b228fd382c","url":"logos/images/FtmJlMdQzXtTYMFcKe3diNjxQYNhTGZEVrSlqEzu.png"},{"revision":"fbedfee06c3bdc1bedaab010353c1c18","url":"offline.html"},{"revision":"3944e28cb89579aa502bb9b3212c5763","url":"sw.js"},{"revision":"a2d5834a309f390346f470ada9ff61b5","url":"vendor/installer/index.8626dda2.css"},{"revision":"2f3089ebbc0b785783018da270980683","url":"vendor/installer/index.9c793cbf.js"},{"revision":"b717051a38182157486700bc748103cd","url":"vendor/installer/vendor.7628f02f.css"},{"revision":"9dba6fadbd180c0851a48eddd5ecf0d6","url":"vendor/installer/vendor.968a0644.js"}]));

const customHandler = async args => {
    try {
        return (
            (await workbox.strategies
                .NetworkFirst({
                    cacheName: 'pages',
                    plugins: [new workbox.expiration.ExpirationPlugin({ maxEntries: 200 })],
                })
                .handle(args)) || caches.match('offline')
        );
    } catch (error) {
        return caches.match('offline');
    }
};

const navigationRoute = new workbox.routing.NavigationRoute(customHandler, {
    blacklist: [new RegExp('/(login|password)')],
});

workbox.routing.registerRoute(navigationRoute);
